package net.kldp.logviewer.common.log.log4j;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.FileAppender;
import org.apache.log4j.spi.LoggingEvent;

/**
 * log4j ׷  α׸   ϴ κ .
 * 
 * @author hangumkj
 *  
 */
public class DatedFileAppender extends FileAppender {

    public DatedFileAppender() {
        m_directory = "logs";
        m_prefix = "tomcat.";
        m_suffix = ".log";
        m_path = null;
        m_calendar = null;
        m_tomorrow = 0L;
    }

    public DatedFileAppender(String s, String s1, String s2) {
        m_directory = "logs";
        m_prefix = "tomcat.";
        m_suffix = ".log";
        m_path = null;
        m_calendar = null;
        m_tomorrow = 0L;
        m_directory = s;
        m_prefix = s1;
        m_suffix = s2;
        activateOptions();
    }

    public String getDirectory() {
        return m_directory;
    }

    public void setDirectory(String s) {
        m_directory = s;
    }

    public String getPrefix() {
        return m_prefix;
    }

    public void setPrefix(String s) {
        m_prefix = s;
    }

    public String getSuffix() {
        return m_suffix;
    }

    public void setSuffix(String s) {
        m_suffix = s;
    }

    public void activateOptions() {
        if (m_prefix == null)
            m_prefix = "";
        if (m_suffix == null)
            m_suffix = "";
        if (m_directory == null || m_directory.length() == 0)
            m_directory = ".";
        m_path = new File(m_directory);
        if (!m_path.isAbsolute()) {
            String s = System.getProperty("catalina.base");
            if (s != null)
                m_path = new File(s, m_directory);
        }
        m_path.mkdirs();
        if (m_path.canWrite())
            m_calendar = Calendar.getInstance();
    }

    public void append(LoggingEvent loggingevent) {
        if (layout == null) {
            errorHandler.error("No layout set for the appender named [" + name
                    + "].");
            return;
        }
        if (m_calendar == null) {
            errorHandler
                    .error("Improper initialization for the appender named ["
                            + name + "].");
            return;
        }
        long l = System.currentTimeMillis();
        if (l >= m_tomorrow) {
            m_calendar.setTime(new Date(l));
            String s = datestamp(m_calendar);
            tomorrow(m_calendar);
            m_tomorrow = m_calendar.getTime().getTime();
            File file = new File(m_path, m_prefix + s + m_suffix);
            fileName = file.getAbsolutePath();
            super.activateOptions();
        }
        if (qw == null) {
            errorHandler
                    .error("No output stream or file set for the appender named ["
                            + name + "].");
            return;
        } else {
            subAppend(loggingevent);
            return;
        }
    }

    public static String datestamp(Calendar calendar) {
        int i = calendar.get(1);
        int j = calendar.get(2) + 1;
        int k = calendar.get(5);
        StringBuffer stringbuffer = new StringBuffer();
        if (i < 1000) {
            stringbuffer.append('0');
            if (i < 100) {
                stringbuffer.append('0');
                if (i < 10)
                    stringbuffer.append('0');
            }
        }
        stringbuffer.append(Integer.toString(i));
        stringbuffer.append('-');
        if (j < 10)
            stringbuffer.append('0');
        stringbuffer.append(Integer.toString(j));
        stringbuffer.append('-');
        if (k < 10)
            stringbuffer.append('0');
        stringbuffer.append(Integer.toString(k));
        return stringbuffer.toString();
    }

    public static void tomorrow(Calendar calendar) {
        int i = calendar.get(1);
        int j = calendar.get(2);
        int k = calendar.get(5) + 1;
        calendar.clear();
        calendar.set(i, j, k);
    }

    private String m_directory;

    private String m_prefix;

    private String m_suffix;

    private File m_path;

    private Calendar m_calendar;

    private long m_tomorrow;
}